/*
 * @(#)insert_object.js 1.2  2006-01-24
 *
 * Copyright (c) 2003-2007 Fachhhochschule Zentralschweiz
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of 
 * Fachhochschule Zentralschweiz. ("Confidential Information"). You 
 * shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you
 * entered into with Fachhochschule Zentralschweiz.
 */ 
/**
 * This file inserts objects into a HTML page, in order to circumvent
 * the Eolas Patent issue with Microsoft Internet Explorer. 
 *
 * This file is intended to be included into the HTML page that displays the video
 * as shown in the sample code below.
 *
 * <html>
 *   <head>
 *     <script language="JavaScript" src="lib/insert_video.js" type="text/JavaScript"></script>
 *   </head>
 *   <body>
 *      <script language="JavaScript" type="text/javascript">insertMovie("path/aMovie.mov",320,240);</script>  
 *   </body>
 * </html>
 *
 * This script is based on the description found at the following page:
 * http://www.apple.com/quicktime/tutorials/embed.html
 *
 * @author Werner Randelshofer
 * @version 1.2 2007-01-24 Function insertApplet added.
 * 1.1 2006-11-02 Renamed from insert_movie.js to insert_object.js.
 * 1.0 2006-06-22 Created.
 */
/**
 * Inserst a QuickTime object into a HTML page.
 *
 * @param movieURL
 * @param width
 * @param height
 * @param id Identification of the object-element/embed-element
 * @return void.
 */
function insertQuickTime(movieURL, width, height, id) {
	document.write('<embed src="'+movieURL+'" ');
	if (id != null) {
		document.write('id="'+id+'" name="'+id+'" ');
	}
	document.write('width="'+width+'" height="'+height+'" '); 
	document.write('controller="true" scale="aspect" ');
	document.write('enablejavascript="true" ');
	document.write('/>');
}
/**
 * Inserts a Flash 8 object into a HTML page.
 *
 * @param swfURL
 * @param width
 * @param height
 * @param id Identification of the object-element/embed-element
 * @return void.
 */
function insertFlash(swfURL, width, height, id) {
	document.write('<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" ');
	if (id != null) {
		document.write('id="'+id+'" ');
	}
	document.write('codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" ');
	document.write('width="'+width+'" height="'+height+'" align="middle">');
    document.write('<param name="allowScriptAccess" value="sameDomain" />');
    document.write('<param name="movie" value="'+swfURL+'" />');
    document.write('<param name="quality" value="high" />');
	document.write('<param name="bgcolor" value="#ffffff" />');
    document.write('<embed src="'+swfURL+'" quality="high" bgcolor="#ffffff" ');
	if (id != null) {
		document.write('id="'+id+'" name="'+id+'"');
	}
	document.write('width="'+width+'" height="'+height+'" align="middle" ');
	document.write('allowscriptaccess="sameDomain" type="application/x-shockwave-flash" ');
	document.write('pluginspage="http://www.macromedia.com/go/getflashplayer" /> ');
    document.write('</object>');
}
/**
 * Inserts a Java Applet into a HTML page.
 * The "mayscript" attribute is set for the applet.
 *
 * Example:
 * insertApplet("ch.fhz.Applet","TheApplet.jar",".",480,460, [
 *   "locale", "en",
 *   "datafile", "blabla.xml"
 * ]);
 *
 *
 * @param code
 * @param archive Can be null
 * @param codebase Can be null
 * @param width
 * @param height
 * @param param An array with name and values. 
 * @return void.
 */
function insertApplet(code, archive, codebase, width, height, param) {
	document.write('<applet ');
	document.write('code="'+code+'" ');
	if (archive != null) {
		document.write('archive="'+archive+'" ');
	}
	if (codebase != null) {
		document.write('codebase="'+codebase+'" ');
	}
	document.write('width="'+width+'" height="'+height+'" ');
	document.write('mayscript ');
	document.write('>');
	if (param != null) {
		for (var i=0; i < param.length; i+=2) {
		    document.write('<param name="'+param[i]+'" value="'+param[i+1]+'" />');
		}
	}
    document.write('</applet>');
}
